<?php
/**
 * @package tara
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	
<div id="page" class="site">
<header id="masthead" class="site-header wrap-content">
  <div id="nav" class="">
  <div id="nav-fixed" class="slide-down">
  <div class="wrap-content">

	<nav id="site-navigation" class="main-navigation">
     <div class="site-branding">
  			<?php
  			the_custom_logo();
  			if ( is_front_page() && is_home() ) :
  				?>
  				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
  				<?php
  			else :
  				?>
  				<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
  				<?php
  			endif;
  			$tara_description = get_bloginfo( 'description', 'display' );
  			if ( $tara_description || is_customize_preview() ) :
  				?>
  				<p class="site-description"><?php echo $tara_description; /* WPCS: xss ok. */ ?></p>
  			<?php endif; ?>
  		</div><!-- .site-branding -->

            <div id="hd-top" >
              <div id="menu-top">
              <?php     
                  wp_nav_menu( array(
              'theme_location' => 'menu-top',
              'menu_id'        => 'menu-top',
            ) );  
              ?>
              </div>
              <!--div id="icon-mxh">
              <?php  //if ( is_active_sidebar('icon')) : dynamic_sidebar('icon'); endif;?> 
              </div-->
              <!-- search & aside toggle -->
              <div class="nav-btns">
                  
                  <button class="search-btn"><i class="fa fa-search"></i></button>
                  <div class="search-form wrap-content">
                      <!--input class="search-input" type="text" name="search" placeholder="Bất cứ thứ gì bạn cần ..."-->
                      <form method="get" class="searchform" action="<?php echo home_url( '/'); ?>" >
                       <!--select class="form-control" name="cat"-->
                       <!--option value="">Toàn bộ</option-->
                       <?php
                       $allcategories= get_categories();
                       foreach ($allcategories as $c) {  }
                       ?>
                       <!--/select-->
                       <input type="text" class="search-input" name="s" value="<?php _e('Hãy nhập tên sản phẩm?', '') ?>" onfocus="if (this.value == '<?php _e('Hãy nhập tên sản phẩm...', '') ?>') {this.value = '';}" onblur="if (this.value == '') {this.value = '<?php _e('Hãy nhập tên sản phẩm...', '') ?>';}" />
                       <!--input type="submit" class="search-submit btn" name="submit" value="Tìm kiếm" /-->
                      </form>
                      <button class="search-close"><i class="fa fa-times"></i></button>
                  </div>
              </div>
              <!-- /search & aside toggle --> 
          </div>

			<!--button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><i class="fa fa-bars"></i></button-->
			<?php
			wp_nav_menu( array(
				'theme_location' => 'menu-1',
				'menu_id'        => 'primary-menu',
			) );
			?>
  <script type="text/javascript" src="<?php echo esc_url( home_url( '/' ) );?>wp-content/themes/tara/js/jquery-3.3.1.min.js"></script>          
 <script type="text/javascript" src="<?php echo esc_url( home_url( '/' ) );?>wp-content/themes/tara/js/menu.js"></script>
 <link rel="stylesheet" type="text/css" href="<?php echo esc_url( home_url( '/' ) );?>wp-content/themes/tara/js/cmenu.css">

          
</nav><!-- #site-navigation -->
</div>  
</div ><!-- #menu -->
</div>     
	</header><!-- #masthead -->