<?php
/*
 * Plugin Name: Tin Tức Landing Page
 * Plugin URI: https://#
 * Description: Widget that displays the featured image of the current post.
 * Version: 1.0
 * Author: Quyen Ga
 * Author URI: https://#
 * License: Q
 * 
 * @package ng-sidebar-featured-image
 * @copyright Copyright (c) 2016, Quyen Ga.
 * @license Q
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class tin_tuc_ld extends WP_Widget
{
    function __construct()
    {
       parent::__construct(
                'tin_tuc_ld',
                __( 'Tin Tức Landing Page', 'ctm' ),
                array('description' => __( 'This plugin displays a list of products of a certain category on your website 1.', 'ctm' )) 
                );
    }
    public function widget( $args, $instance ) {
        extract( $args );
        $title = apply_filters( 'widget_title', $instance['title']);
        $ids   = $instance['ids'];
        $soluong   = $instance['soluong'];
        $arr_id = explode(',',$ids);
        global $post;
        $args_array = array( 'posts_per_page' => $soluong, 'category' => $ids,'orderby' => 'rand' );
        $myposts = get_posts( $args_array ); ?>
        <div class="tt-ldp">
        <div class="wrap-content me-fix">
        <div class="tt-moi1 tt-home"><span><?php echo $title; ?></span></div>
        <p><?php echo category_description($ids); ?></p>
            <ul>
                <?php
               
                foreach ( $myposts as $post ) : setup_postdata( $post ); ?>
                	<li>
                       <div class="hinhsb"><img alt="<?php echo get_the_title(); ?>" src="<?php echo esc_url( home_url( '/' ).'wp-content/themes/tara/timthumb.php?src='.get_the_post_thumbnail_url().'&h=300&w=300');?>" /></div>
                       <div class="mta">
                        <span class="tt-tinmoi" ><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></span>
                        <p><?php echo the_excerpt_max_charlength(100); ?></p>
                       </div>
                	</li>
                <?php endforeach; 
                wp_reset_postdata();?>
                
            </ul>
        </div>
        </div>    
        <?php 
    } 

    
    // Widget Backend
    public function form($instance){
        $title = (isset($instance['title'])) ? $instance['title'] : __( 'Products', 'ndb' );
        $ids = $instance['ids'];
        $soluong = $instance['soluong'];
       ?>
        <p>

           <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"  name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('ids'); ?>"><?php _e('Category:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('ids'); ?>"  name="<?php echo $this->get_field_name( 'ids' ); ?>" type="text" value="<?php echo esc_attr( $ids ); ?>" />
        </p>
        <p>
           <label for="<?php echo $this->get_field_id('soluong'); ?>"><?php _e('Số Lượng:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('soluong'); ?>"  name="<?php echo $this->get_field_name( 'soluong' ); ?>" type="text" value="<?php echo esc_attr( $soluong ); ?>" />
        </p>
        <?php

   }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['ids'] = ( ! empty( $new_instance['ids'] ) ) ? strip_tags( $new_instance['ids'] ) : '';
        $instance['soluong'] = ( ! empty( $new_instance['soluong'] ) ) ? strip_tags( $new_instance['soluong'] ) : '';
        return $instance;
    }

}
add_action( 'widgets_init', function(){
    register_widget( 'tin_tuc_ld' );
} );

?>