<?php
/*
 * Plugin Name: Khách Hàng
 * Plugin URI: https://#
 * Description: Widget that displays the featured image of the current post.
 * Version: 1.0
 * Author: Quyen Ga
 * Author URI: https://#
 * License: Q
 * 
 * @package ng-sidebar-featured-image
 * @copyright Copyright (c) 2016, Quyen Ga.
 * @license Q
*/
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class Nhan_vien extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
                'Nhan_vien',
                __( 'Nhân Viên', 'ctm' ),
                array('description' => __( 'This plugin displays a list of products of a certain category on your website 1.', 'ctm' )) 
                );
    }
    public function widget( $args, $instance ) {
        extract( $args );
        $title = apply_filters( 'widget_title', $instance['title']);
        $ids   = $instance['ids'];
        $arr_id = explode(',',$ids);
        global $post;
        $args_array = array( 'posts_per_page' => 4, 'category' => $ids,'orderby' => 'rand' );
        $myposts = get_posts( $args_array ); ?>
        <div class="khach-hang">
        <div id="khach-hang" class="wrap-content">
        <h2 class="tt-home"><span><?php echo $title; ?></span></h2>
       <hr />
            <ul>
                <?php
               foreach ( $myposts as $post ) : setup_postdata( $post ); ?>
                	<li>
                        <div class="ddb"><img alt="<?php echo get_the_title(); ?>" src="<?php echo esc_url( home_url( '/' ).'wp-content/themes/tara/timthumb.php?src='.get_the_post_thumbnail_url().'&h=200&w=200');?>" />
                        <h5 class="title3"><a ><?php the_title(); ?></a></h5>
                        <p><?php  the_excerpt_max_charlength(300);?></p>
                        </div>
                	</li>
                <?php endforeach; 
                wp_reset_postdata();?>
                
            </ul>
        </div>
        </div>
                  
        <?php 
    } 

    // Widget Backend
    public function form($instance){
        $title = (isset($instance['title'])) ? $instance['title'] : __( 'Products', 'ndb' );
        $ids = $instance['ids'];
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"  name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('ids'); ?>"><?php _e('Category:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('ids'); ?>"  name="<?php echo $this->get_field_name( 'ids' ); ?>" type="text" value="<?php echo esc_attr( $ids ); ?>" />
        </p>
        <?php

    }
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['ids'] = ( ! empty( $new_instance['ids'] ) ) ? strip_tags( $new_instance['ids'] ) : '';
        return $instance;
    }
}
add_action( 'widgets_init', function(){
    register_widget( 'Nhan_vien' );
} );
?>